<?php
require __DIR__ . '/vendor/autoload.php';
use Ratchet\MessageComponentInterface;
use Ratchet\ConnectionInterface;

class PrintServer implements MessageComponentInterface {
    protected $clients;
    public function __construct(){ $this->clients = new \SplObjectStorage; }
    public function onOpen(ConnectionInterface $conn){
        $this->clients->attach($conn);
        $conn->send(json_encode(['event'=>'handshake','data'=>['server_type'=>'php','version'=>PHP_VERSION]]));
    }
    public function onMessage(ConnectionInterface $from, $msg){
        if($msg==='ping'){ $from->send('pong'); return; }
        $data=@json_decode($msg,true);
        if(isset($data['event'])){
            foreach($this->clients as $c){
                if($c!==$from) $c->send($msg);
            }
        }
    }
    public function onClose(ConnectionInterface $conn){ $this->clients->detach($conn); }
    public function onError(ConnectionInterface $conn, \Exception $e){ $conn->close(); }
}
use Ratchet\Server\IoServer;
use Ratchet\Http\HttpServer;
use Ratchet\WebSocket\WsServer;
$server = IoServer::factory(new HttpServer(new WsServer(new PrintServer())), 8080);
$server->run();