const WebSocket = require('ws');
const PORT = process.env.NODE_WS_PORT || 7071;
const wss = new WebSocket.Server({ port: PORT }, ()=> {
  console.log('[NodeWS] Listening on', PORT);
});
function broadcast(obj, except){
  const msg=JSON.stringify(obj);
  for(const c of wss.clients){
    if(c.readyState===WebSocket.OPEN && c!==except){
      c.send(msg);
    }
  }
}
wss.on('connection', ws=>{
  ws.send(JSON.stringify({event:'handshake', data:{server_type:'node', version:process.version}}));
  ws.on('message', data=>{
    const txt=data.toString();
    if(txt==='ping'){ ws.send('pong'); return; }
    let obj;
    try{ obj=JSON.parse(txt); }catch{return;}
    if(obj.event) broadcast(obj, ws);
  });
});